DROP PROCEDURE [hips].[HealthProviderOrganisationPatientGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon
-- Description:   Gets a specific record from the HealthProviderOrganisationPatient Table
-- Create date: 18 December 2012
-- =============================================
CREATE PROCEDURE [hips].[HealthProviderOrganisationPatientGet] 
(
	  @HealthProviderOrganisationId INT = NULL
	, @PatientMasterId INT = NULL
	, @HpiO VARCHAR(16) = NULL
	, @DateModified DATETIME = NULL
)
AS
BEGIN
	SELECT    hpop.[HealthProviderOrganisationId]
			, hpop.[PatientMasterId]
			, hpop.[PcehrAdvertised]
			, hpop.[AccessCodeRequiredId]
			, hpop.[PcehrDisclosed]
			, hpop.[DateCreated]
			, hpop.[UserCreated]
			, hpop.[DateModified]
			, hpop.[UserModified]
		
FROM  hips.HealthProviderOrganisationPatient hpop
INNER JOIN hips.HealthProviderOrganisation hpo ON hpo.HealthProviderOrganisationId = hpop.HealthProviderOrganisationId
WHERE (hpop.PatientMasterID = @PatientMasterID OR @PatientMasterId IS NULL)
AND (hpop.HealthProviderOrganisationId = @HealthProviderOrganisationId OR @HealthProviderOrganisationId IS NULL)
AND (hpo.HpiO = @HpiO OR @HpiO IS NULL)
AND (hpop.DateModified >= @DateModified OR @DateModified IS NULL)
END
GO

